package com.agilex.healthcare.veteranappointment.domain;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObject;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "appointmentMetric", namespace = Namespace.VeteranAppointmentRequest)
@XmlAccessorType(value = XmlAccessType.NONE)
public class VARAppointmentMetric extends DomainTransferObject {

	private static final long serialVersionUID = -5522577028369091396L;
	
	@XmlElement
	private String name;
	
	@XmlElement
	private int value;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public int getValue() {
		return value;
	}

	public void setValue(int value) {
		this.value = value;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		result = prime * result + value;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		boolean result = false;
		if (this == obj) {
			result = true;
		} else if (obj != null && obj instanceof VARAppointmentMetric) {
            VARAppointmentMetric that = (VARAppointmentMetric) obj;

			if (equals(name, that.name)) {
				if (value == that.value) {
					result = true;
				}
			}
		}
		
		return result;
	}
	
	private boolean equals(Object one, Object two) {
		boolean result = false;
		if ((one == null && two == null)
				|| (one != null && one.equals(two))) {
			result = true;
		}
		return result;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(name);
		sb.append(": ");
		sb.append(value);
		
		return sb.toString();
	}
}
